<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TpmController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\IndexoibddController;
use App\Http\Controllers\IndexoimailController;
use App\Http\Controllers\TpmdatabaseController;




Route::middleware('auth')->group(function () {
    Route::get('/', function () {
        return view('auth.login');
    });
    
    Route::get('/Accueil', function () {
        return view('home');
    })->middleware(['auth', 'verified'])->name('dashboard');
    Route::get('/Technopet',[TpmController::class, 'technopet'])->name('technopet');
    Route::get('/Technopet-mail',[TpmController::class, 'mail'])->name('mail');
    Route::get('/Technopet-mail/{id}',[TpmController::class, 'edit'])->name('edit-mail');
    Route::get('/Technopet-mail/add-mail',[TpmController::class, 'addmail'])->name('addmail');
    Route::get('/Technopet-les-parametres',[TpmdatabaseController::class, 'database'])->name('database');
    Route::get('/Index-Oi',[IndexoimailController::class, 'indexoi'])->name('indexoi');
    Route::get('/Index-Oi-mail',[IndexoimailController::class, 'mail'])->name('indexoi-mail');
    Route::get('/Index-Oi-les-parametres',[IndexoibddController::class, 'database'])->name('indexoi-database');
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    Route::get('/register', [UserController::class, 'register'])->name('register');
    Route::post('/Sign_up', [UserController::class, 'signup'])->name('signup');
});

require __DIR__.'/auth.php';
