<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Indexoimail;
use Illuminate\Http\Request;
use Livewire\WithPagination;

class Mailindexoi extends Component
{
    use WithPagination;
    public $search = '';
    public $mail, $password, $compte_id;
    public $updateMail = false;
    public $createEmail = false;
    protected $queryString =[
        'search' => ['except'=>'']
    ];
    public function resetFields()
    {
        $this->mail = '';
        $this->password = '';
    }
    public function render()
    {
        return view('livewire.indexoi.mail.indexoimail',[
            'mails' => Indexoimail::where('mail', 'LIKE', "%{$this->search}%")->paginate(5)
        ]);
    }
    public function store()
    {
        $this->validate([
            'mail' => 'required'
        ]);
        Indexoimail::create([
            'mail'=>$this->mail,
            'pass' =>$this->password
        ]);
        $this->resetFields();
        session()->flash('success', 'Email Created Successfully');
        
        $this->createEmail = false;
    }
    public function edit($id)
    {
        $mail = Indexoimail::find($id);
        $this->mail = $mail->mail;
        $this->password = $mail->pass;
        $this->compte_id = $mail->id;
        $this->updateMail = true;
    }
    public function cancel()
    {
        
        $this->updateMail = false;
        $this->resetFields();
    }
    public function update()
    {
        IndexoiMail::find($this->compte_id)->fill([
           'mail'=>$this->mail,
           'pass'=>$this->password 
        ])->save();
        session()->flash('success', 'Email updated Successfully');
        
        $this->updateMail = false;
        $this->resetFields();
    }
    public function delete($id)
    {
        Indexoimail::find($id)->delete();
    }
    public function create()
    {
        $this->createEmail = true;
        $this->resetFields();
    }
    public function cancelAdd()
    {
        $this->createEmail = false;
        $this->resetFields();
    }
}
